﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
using System.Threading;

namespace XOR_FILE_001
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //open file dialog
            OpenFileDialog ofd1 = new OpenFileDialog();
            ofd1.Filter = "All Files (*.*)|*.*";
            ofd1.ShowDialog();
            textBox1.Text = ofd1.FileName;
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //save file dialog
            SaveFileDialog sfd1 = new SaveFileDialog();
            sfd1.Filter = "All Files (*.*)|*.*";
            sfd1.ShowDialog();
            textBox2.Text = sfd1.FileName;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            //save file dialog
            SaveFileDialog sfd2 = new SaveFileDialog();
            sfd2.Filter = "All Files (*.*)|*.*";
            sfd2.ShowDialog();
            textBox3.Text = sfd2.FileName;
        }

        private void button4_Click(object sender, EventArgs e)
        {
            //open file dialog
            OpenFileDialog ofd3 = new OpenFileDialog();
            ofd3.Filter = "All Files (*.*)|*.*";
            ofd3.ShowDialog();
            textBox4.Text = ofd3.FileName;
        }

        private void button7_Click(object sender, EventArgs e)
        {


            try
            {
                
                //status change
                status_text.Text = "LOADING FILE...";
                this.Refresh();
                Application.DoEvents();
                Thread.Sleep(1000);
                
                //load input
                byte[] inputArray = File.ReadAllBytes(textBox1.Text);

                //populate and encode output array
                Random rnd1 = new Random(Environment.TickCount);
                Queue<int> line1 = new Queue<int>();
                Queue<int> line2 = new Queue<int>();

                status_text.Text = "ENCODING FILE...";
                for (int i = 0; i < inputArray.Length; i++)
                {
                    byte offset = (byte)rnd1.Next(0, 256);
                    line1.Enqueue(offset);
                    byte encoded = inputArray[i];
                    line2.Enqueue(encoded ^ offset);

                }

                //convert queue to arrays
                int[] ar_line1 = line1.ToArray();
                int[] ar_line2 = line2.ToArray();

                byte[] byte_line1 = new byte[ar_line1.Length];
                byte[] byte_line2 = new byte[ar_line2.Length];

                for (int i = 0; i < ar_line1.Length; i++)
                {
                    byte_line1[i] = (byte)ar_line1[i];
                    byte_line2[i] = (byte)ar_line2[i];
                }

                //write to file
                status_text.Text = "WRITING FILES...";
                this.Refresh();
                Application.DoEvents();
                Thread.Sleep(1000);

                File.WriteAllBytes(textBox2.Text, byte_line1);
                File.WriteAllBytes(textBox3.Text, byte_line2);

                //done
                status_text.Text = "READY.";
                this.Refresh();
                Application.DoEvents();
                Thread.Sleep(1000);
            }
            catch(Exception e1)
            {
                //show error
                status_text.Text = "ERROR.";
                this.Refresh();
                Application.DoEvents();
                Thread.Sleep(1000);
                MessageBox.Show("ERROR SPLITTING FILE.\n\n" + e1.Message);
            }

        }

        private void button5_Click(object sender, EventArgs e)
        {
            //open file dialog
            OpenFileDialog ofd5 = new OpenFileDialog();
            ofd5.Filter = "All Files (*.*)|*.*";
            ofd5.ShowDialog();
            textBox5.Text = ofd5.FileName;
        }

        private void button6_Click(object sender, EventArgs e)
        {
            //save file dialog
            SaveFileDialog sfd6 = new SaveFileDialog();
            sfd6.Filter = "All Files (*.*)|*.*";
            sfd6.ShowDialog();
            textBox6.Text = sfd6.FileName;
        }

        private void button8_Click(object sender, EventArgs e)
        {
            try
            {
                //status change
                status_text.Text = "READING INPUT FILES...";
                this.Refresh();
                Application.DoEvents();
                Thread.Sleep(1000);

                //load input
                byte[] inputArray1 = File.ReadAllBytes(textBox4.Text);
                byte[] inputArray2 = File.ReadAllBytes(textBox5.Text);

                //status change
                status_text.Text = "MERGING FILES...";
                this.Refresh();
                Application.DoEvents();
                Thread.Sleep(1000);

                //validate sizes
                if (inputArray1.Length == inputArray2.Length)
                {

                    // combine and store output
                    Queue<byte> outputArray = new Queue<byte>();
                    for (int i = 0; i < inputArray1.Length; i++)
                    {
                        int outCombine = inputArray1[i] ^ inputArray2[i];
                        outputArray.Enqueue((byte)outCombine);
                    }

                    //load output array
                    byte[] ar_line2 = outputArray.ToArray();

                    //write to file
                    status_text.Text = "WRITING OUTPUT FILE...";
                    this.Refresh();
                    Application.DoEvents();
                    Thread.Sleep(1000);
                    File.WriteAllBytes(textBox6.Text, ar_line2);

                    //done
                    status_text.Text = "READY.";
                    this.Refresh();
                    Application.DoEvents();
                    Thread.Sleep(1000);

                }
                else
                {
                    //show error
                    status_text.Text = "ERROR.";
                    this.Refresh();
                    Application.DoEvents();
                    Thread.Sleep(1000);
                    MessageBox.Show("INPUT FILES ARE DIFFERENT SIZE.");
                }


            }
            catch(Exception e2)
            {
                //show error
                status_text.Text = "ERROR.";
                this.Refresh();
                Application.DoEvents();
                Thread.Sleep(1000);
                MessageBox.Show("ERROR MERGING FILES.\n\n" + e2.Message);
            }
        }

        private void fileToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void fileToolStripMenuItem_Click_1(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void aBOUTToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //load about form
            Form2 myNewForm = new Form2();
            myNewForm.ShowDialog(this);
        }
    }
}
